//	Utils.h

#ifndef _H_Utils
#define _H_Utils

#include "Carbon68kGlue.h"

#ifndef LoShort
	#define	LoShort(_X_)	(short)((_X_) & 0x0000FFFF)
	#define	HiShort(_X_)	(short)(((_X_) & 0xFFFF0000) >> 16)
#endif

#ifndef HiByte
	#define	LoByte(_X_)		(Byte)((_X_) & 0x00FF)
	#define	HiByte(_X_)		(Byte)(((_X_) & 0xFF00) >> 8)
#endif

unsigned char *	c2p(const char *strZ);

extern	Rect		gEmptyRect;

#define		LERP(to_min, to_max, from, from_min, from_max)	\
	((from_max) == (from_min) ? from : 						\
	(double)(to_min) + ((double)((to_max) - (to_min))		\
		* ((double)((from) - (from_min))					\
		/ (double)((from_max) - (from_min)))))

Boolean		TrackMouseRgn(
	RgnHandle	rgnH,
	void		(*HilightProc)(RgnHandle rgnH, void *data, Boolean in, Boolean Last),
	void		(*TrackingProc)(void *data),
	void		*data);

Boolean		TrackMouse1(
	Rect *theRectPtr,
	void (*HilightProc)(Rect *theRect, void *data, Boolean in, Boolean Last),
	void (*TrackingProc)(void *data),
	void *data
);

#define		kTrackHorizontal	0x01
#define		kTrackVertical		0x02
#define		kTrackAll			0x03
Boolean		MouseMoved(int direction);

void		WaitNTicks(long ticks);

#ifndef ulong
	typedef	unsigned long	ulong;
	typedef	unsigned short	ushort;
#endif

void	TicksToTime(
	ulong ticksUL, 
	short *hoursS, 
	short *minutesS, 
	short *secondsS);
	
Boolean		MouseStateChanged(
	Point	start_pt, 
	long	timeout_ticksL, 
	short	pix_deltaS, 
	Boolean	*movedPB, 
	Boolean	*button_upPB);

char	*TimeToString(short hoursS, short minutesS, short secondsS, char *buf);
char	*FormatTicks(ulong ticksUL, char *buf);
Rect	PointToRect(Point thePoint, short size, short extra);

int			check_key_down(long key_mask);
#define		shift_key		0x00000001
#define 	caps_lock		0x00000002
#define		option_key		0x00000004
#define 	control_key		0x00000008
#define		tab_key			0x00000100
#define		space_key		0x00000200
#define		tilde_key		0x00000400
#define		delete_key		0x00000800
#define		esc_key			0x00002000
#define		command_key		0x00008000


#define		LEFT_ARROW_KEY		0x1C
#define		RIGHT_ARROW_KEY		0x1D
#define		UP_ARROW_KEY		0x1E
#define		DOWN_ARROW_KEY		0x1F

#define		ENTER_KEY			0x03
#define		DELETE_KEY			0x08
#define		FWD_DELETE_KEY		0x7F
#define		TAB_KEY				0x09
#define		RETURN_KEY			0x0D
#define		ESC_CLEAR_KEY		0x1B

#define	IS_DIGIT(_C)	((_C) >= '0' && (_C) <= '9')

#define	IS_HEX_DIGIT(_C)	\
	(IS_DIGIT(_C) || ((_C) >= 'A' && (_C) <= 'F') || ((_C) >= 'a' && (_C) <= 'f'))

typedef unsigned char uchar;

char	Upcase(char c);
void	ConcatNumToString(void *srcStr1, long theNum, void *dstString);
void	DrawOnlyGrowIcon(WindowPtr theWindow);
void	ShrinkString(void *theString, int space_for_string);
char	*ShrinkCString(char *buf, short width);
void	CopyString(uchar *srcString, uchar *dstString);
void	Concat(uchar *srcStr1, uchar *srcStr2, uchar *dstString);
char	*FormatSize(ulong bytes, char *buf);
void	MeasureCString(char *buf, Rect *theRect);
void	DrawCString(char *buf);

char	VirtualASCII(EventRecord *eventP);
void	memfill(void *mem, char value, unsigned long size);
void	memclr(void *mem, unsigned long size);

Boolean			StillDown_Loop(void);
FMFontFamily	GetAppFonts(short column_widthS);

void		GlobalRectToLocal(GrafPtr portP, Rect *theRect);
void		LocalRectToGlobal(GrafPtr portP, Rect *theRect);
void		OpenClipRect(void);

char		*FormatWithCommas(ulong bytes, char *buf);

//	for TESetFont
#define		doMode		64
void	TESetFont(
  short              mode,
  const TextStyle *  newStyle,
  Boolean            fRedraw,
  TEHandle           hTE);

void	TEGetSelect(
	TEHandle	hTE, 
	long		*selStart,
	long		*selEnd);

#define		SetEmptyRect(_foo)	SetRect(_foo, 0, 0, 0, 0)

void		DrawCStringInRect(char *buf, Rect *theRect, short justifyS);
ushort		CStringWidth(char *buf);
short		CompareCString(char *strA, char *strB);
short		ComparePString(unsigned char *strA, unsigned char *strB);

Boolean		Is_OS_X(void);
ushort		GetSystemVers(void);
ushort		GetInterfaceVers(void);

void		SetDragging(Boolean isDraggingB);
Boolean		IsDragging(void);

typedef struct {
	unsigned char	fontName[256];
	short			fontID;
	short			fontSize;
	Style			fontFace;
	short			fontMode;
} ADFS_FontRec;

void		GetCurFontRec(ADFS_FontRec *fontRecP);
void		GetSysFontRec(ADFS_FontRec *fontRecP);
void		GetSmallFontRec(ADFS_FontRec *fontRecP);
void		SetFontRec(ADFS_FontRec *fontRecP);

#define		arrowCursor		0
void		SetStandardCursor(short cursorID);

void		ZoomRect(Rect *start, Rect *end);
long		CompareTime(DateTimeRec *dtA, DateTimeRec *dtB);

void	FlushCurPort(void);

typedef enum {
	QD_Triangle_NONE, 

	QD_Triangle_UP, 
	QD_Triangle_DOWN, 
	QD_Triangle_RIGHT, 
	QD_Triangle_LEFT, 

	QD_Triangle_NUMTYPES
} QD_TriangleType;

void		DrawTriangle(QD_TriangleType type, Rect *rectP);
Boolean		IsADFS(void);
OSType		GetAppCreator(void);

void	SpeakCString(char *strZ, long lengthL = 0);
void	Idle_DisposeSpeechChannel(Boolean forceB = FALSE);

#endif

